<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Account
 * @package App\Models
 * @version December 29, 2020, 1:42 pm UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection $movements
 * @property \Illuminate\Database\Eloquent\Collection $movement1s
 * @property \Illuminate\Database\Eloquent\Collection $pays
 * @property \Illuminate\Database\Eloquent\Collection $readyAccounts
 * @property integer $parent_id
 * @property string $name
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Account extends Model
{

    public $table = 'accounts';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';



    public $fillable = [
        'parent_id',
        'name',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'parent_id' => 'integer',
        'name' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'parent_id' => 'nullable',
        'name' => 'required|string|max:191',
        'param1' => 'nullable|string|max:191',
        'param2' => 'nullable|string|max:191',
        'param3' => 'nullable|string|max:191',
        'param4' => 'nullable|string|max:191',
        'param5' => 'nullable|string|max:191',
        'param6' => 'nullable|string|max:191',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function movements()
    {
        return $this->hasMany(\App\Models\Movement::class, 'account_gp_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function movement1s()
    {
        return $this->hasMany(\App\Models\Movement::class, 'account_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function pays()
    {
        return $this->hasMany(\App\Models\Pay::class, 'account_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function readyAccounts()
    {
        return $this->hasMany(\App\Models\ReadyAccount::class, 'account_id');
    }
}
