<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Employee
 * @package App\Models
 * @version December 29, 2020, 1:49 pm UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection $loans
 * @property \Illuminate\Database\Eloquent\Collection $loanMovements
 * @property string $name
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Employee extends Model
{

    public $table = 'employees';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'name',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'nullable|string|max:191',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function loans()
    {
        return $this->hasMany(\App\Models\Loan::class, 'employee_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function loanMovements()
    {
        return $this->hasMany(\App\Models\LoanMovement::class, 'employee_id');
    }
}
