<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class LoanMovement
 * @package App\Models
 * @version December 29, 2020, 1:50 pm UTC
 *
 * @property \App\Models\AccountantYear $accountantYear
 * @property \App\Models\Employee $employee
 * @property \App\Models\Loan $loan
 * @property \App\Models\Pay $pay
 * @property integer $employee_id
 * @property integer $pay_id
 * @property integer $loan_id
 * @property integer $accountant_year_id
 * @property integer $year
 * @property integer $amount
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class LoanMovement extends Model
{

    public $table = 'loan_movement';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'employee_id',
        'pay_id',
        'loan_id',
        'accountant_year_id',
        'year',
        'amount',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'employee_id' => 'integer',
        'pay_id' => 'integer',
        'loan_id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'amount' => 'integer',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'employee_id' => 'required',
        'pay_id' => 'required',
        'loan_id' => 'required',
        'accountant_year_id' => 'required',
        'year' => 'required|integer',
        'amount' => 'required',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function employee()
    {
        return $this->belongsTo(\App\Models\Employee::class, 'employee_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function loan()
    {
        return $this->belongsTo(\App\Models\Loan::class, 'loan_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function pay()
    {
        return $this->belongsTo(\App\Models\Pay::class, 'pay_id');
    }
}
