<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Phone
 * @package App\Models
 * @version December 20, 2020, 11:19 am UTC
 *
 * @property \App\Models\Company $company
 * @property \App\Models\Person $person
 * @property \App\Models\User $updatedBy
 * @property \App\Models\User $user
 * @property integer $user_id
 * @property integer $updated_by
 * @property integer $person_id
 * @property integer $company_id
 * @property string $phone_number
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Phone extends Model
{


    public $table = 'phones';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'user_id',
        'updated_by',
        'person_id',
        'company_id',
        'phone_number',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'updated_by' => 'integer',
        'person_id' => 'integer',
        'company_id' => 'integer',
        'phone_number' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'user_id' => 'required',
        'updated_by' => 'required',
        'person_id' => 'nullable',
        'company_id' => 'nullable',
        'phone_number' => 'required|string|max:191',
        'param1' => 'nullable|string|max:191',
        'param2' => 'nullable|string|max:191',
        'param3' => 'nullable|string|max:191',
        'param4' => 'nullable|string|max:191',
        'param5' => 'nullable|string|max:191',
        'param6' => 'nullable|string|max:191',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function company()
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function person()
    {
        return $this->belongsTo(\App\Models\Person::class, 'person_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function updatedBy()
    {
        return $this->belongsTo(\App\User::class, 'updated_by');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }
}
