<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ReadyAccount
 * @package App\Models
 * @version December 29, 2020, 2:12 pm UTC
 *
 * @property \App\Models\Account $account
 * @property integer $account_id
 * @property integer $type
 * @property string $name
 * @property integer $amount
 */
class ReadyAccount extends Model
{

    public $table = 'ready_account';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';


    protected $with = [
        'account',
    ];


    public $fillable = [
        'account_id',
        'type',
        'index',
        'name',
        'amount'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'account_id' => 'integer',
        'index' => 'integer',
        'type' => 'integer',
        'name' => 'string',
        'amount' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'account_id' => 'required',
        'type' => 'required|integer',
        'name' => 'required|string|max:191',
        'amount' => 'required',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function account()
    {
        return $this->belongsTo(\App\Models\Account::class, 'account_id');
    }
}
