<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Receive
 * @package App\Models
 * @version December 29, 2020, 1:43 pm UTC
 *
 * @property \App\Models\AccountantYear $accountantYear
 * @property \App\Models\Company $company
 * @property \App\Models\Person $person
 * @property \App\Models\User $user
 * @property \Illuminate\Database\Eloquent\Collection $grantPeople
 * @property \Illuminate\Database\Eloquent\Collection $movements
 * @property integer $sequence
 * @property integer $user_id
 * @property integer $accountant_year_id
 * @property integer $year
 * @property boolean $status
 * @property integer $person_id
 * @property integer $company_id
 * @property string $name
 * @property boolean $type
 * @property string $date
 * @property string $note
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Receive extends Model
{


    public $table = 'receive';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    protected $with = [
        'movements',
        'person',
        'company',
        'grantPeople',
        'user'
    ];





    public $fillable = [
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'person_id',
        'company_id',
        'name',
        'type',
        'date',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'sequence' => 'integer',
        'user_id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'status' => 'integer',
        'person_id' => 'integer',
        'company_id' => 'integer',
        'name' => 'string',
        'type' => 'integer',

        'date' => 'date:Y/m/d',
        'note' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'sequence' => 'required|integer',
        'user_id' => 'required',
        'accountant_year_id' => 'required',
        'year' => 'required|integer',
        'status' => 'required|boolean',
        'person_id' => 'nullable',
        'company_id' => 'nullable',
        'name' => 'nullable|string|max:191',
        'type' => 'required|boolean',
        'date' => 'nullable',
        'note' => 'nullable|string',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function company()
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function person()
    {
        return $this->belongsTo(\App\Models\Person::class, 'person_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function grantPeople()
    {
        return $this->hasMany(\App\Models\GrantPerson::class, 'receive_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function movements()
    {
        return $this->hasMany(\App\Models\Movement::class, 'receive_id');
    }
}
