<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Sequence
 * @package App\Models
 * @version December 24, 2020, 6:54 pm UTC
 *
 * @property string $name
 * @property integer $sequence
 */
class Sequence extends Model
{

    public $table = 'sequences';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'name',
        'sequence',
        'year',
        'accountant_year_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'sequence' => 'integer',
        'year' => 'integer',
        'accountant_year_id' => 'integer',
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required|string|max:191',
        'sequence' => 'required|integer',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];
}
