<?php

namespace App\Repositories;

use App\Models\AccountantYear;
use App\Repositories\BaseRepository;

/**
 * Class AccountantYearRepository
 * @package App\Repositories
 * @version December 29, 2020, 5:52 pm UTC
*/

class AccountantYearRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'year',
        'user_id',
        'status',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return AccountantYear::class;
    }
}
