<?php

namespace App\Repositories;

use App\Models\CC;
use App\Repositories\BaseRepository;

/**
 * Class CCRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:51 pm UTC
*/

class CCRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'updated_by',
        'request_id',
        'name',
        'city',
        'hire_date',
        'degree',
        'record_no',
        'logo',
        'mailbox',
        'nativity',
        'address',
        'trade_type',
        'status',
        'is_deleted',
        'status_description',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return CC::class;
    }
}
