<?php

namespace App\Repositories;

use App\Models\CompanyDetail;
use App\Repositories\BaseRepository;

/**
 * Class CompanyDetailRepository
 * @package App\Repositories
 * @version December 20, 2020, 8:23 am UTC
*/

class CompanyDetailRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'company_id',
        'name',
        'mother_name',
        'father_name',
        'digit',
        'birthday',
        'is_authorized',
        'status',
        'status_description',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return CompanyDetail::class;
    }
}
