<?php

namespace App\Repositories;

use App\Models\Deposit;
use App\Repositories\BaseRepository;

/**
 * Class DepositRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:42 pm UTC
*/

class DepositRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'notification_num',
        'date',
        'account_name',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Deposit::class;
    }
}
