<?php

namespace App\Repositories;

use App\Models\GrantPerson;
use App\Repositories\BaseRepository;

/**
 * Class GrantPersonRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:48 pm UTC
*/

class GrantPersonRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'person_id',
        'company_id',
        'receive_id',
        'accountant_year_id',
        'year',
        'name',
        'date',
        'amount',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return GrantPerson::class;
    }
}
