<?php

namespace App\Repositories;

use App\Models\Plain;
use App\Repositories\BaseRepository;

/**
 * Class PlainRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:43 pm UTC
*/

class PlainRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'date',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Plain::class;
    }
}
