<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

use Tymon\JWTAuth\Contracts\JWTSubject;

use Illuminate\Support\Facades\Hash;

class User extends Authenticatable implements JWTSubject
{

    use Notifiable;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $table = 'users';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';




    public $fillable = [
        'username',
        'password',
        'status',
        'role',
        'device_id',
        'notes',
        'notes2',
        'notes3',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6',
        'remember_token'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'username' => 'string',
        'password' => 'string',
        'status' => 'integer',
        'role' => 'integer',
        'device_id' => 'string',
        'notes' => 'string',
        'notes2' => 'string',
        'notes3' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'remember_token' => 'string'
    ];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token', 'device_id',
    ];




    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::make($value);
    }
}
