<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username')->unique();

            $table->string('password');

            $table->unsignedTinyInteger('status')->default(0); // 0 = active , 1 = inactive GLOBAL

            $table->unsignedTinyInteger('role')->default(0); //  0=admin , 1=Affiliation Department user, 2=Print certificates Department user , 3=Accountant

            $table->string('device_id')->nullable();

            $table->longText('notes')->nullable();
            $table->longText('notes2')->nullable();
            $table->longText('notes3')->nullable();

            $table->string('param1')->nullable();
            $table->string('param2')->nullable();
            $table->string('param3')->nullable();
            $table->string('param4')->nullable();
            $table->string('param5')->nullable();
            $table->string('param6')->nullable();
            $table->longText('remember_token')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
