<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('cascade');

            $table->string('name')->nullable();
            $table->string('city')->nullable();
            $table->date('hire_date')->nullable();
            $table->string('degree')->nullable();
            $table->string('record_no')->nullable();
            $table->string('logo')->nullable();
            $table->string('mailbox')->nullable();
            $table->string('nativity')->nullable();
            $table->text('address')->nullable();
            $table->text('trade_type')->nullable();
            $table->string('phone1')->nullable();
            $table->string('phone2')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('location')->nullable();
            $table->string('digit')->nullable();
            $table->string('year')->nullable();
            $table->string('personality_number')->nullable();
            $table->string('out_from')->nullable();
            $table->unsignedTinyInteger('type')->default(0); //persons =0 , companies = 1;
            $table->string('param1')->nullable();
            $table->string('param2')->nullable();
            $table->string('param3')->nullable();
            $table->string('param4')->nullable();
            $table->string('param5')->nullable();
            $table->string('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies_requests');
    }
}
