<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccountantYearsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accountant_years', function (Blueprint $table) {
            $table->id();
            $table->integer('year');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->unsignedTinyInteger('status')->default(0); // 0 =editable , 1= not editable
            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accountant_years');
    }
}
