<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReceiveTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receive', function (Blueprint $table) {
            $table->id();
            $table->integer('sequence');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('accountant_year_id')->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year');
            $table->unsignedTinyInteger('status')->default(0); // 0 =active , 1= inactive
            //************************ */
            $table->foreignId('person_id')->nullable()->constrained('persons')->onDelete('cascade');
            $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');

            $table->string('name')->nullable();
            $table->unsignedTinyInteger('type')->default(0); // 0 =person , 1=company , 2= other

            $table->date('date')->nullable();

            $table->text('note')->nullable();
            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recieve');
    }
}
