<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGrantPersonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grant_persons', function (Blueprint $table) {
            $table->id();
            $table->foreignId('person_id')->nullable()->constrained('persons')->onDelete('cascade');
            $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
            $table->foreignId('company_detail_id')->nullable()->constrained('company_details')->onDelete('cascade');

            $table->foreignId('receive_id')->constrained('receive')->onDelete('cascade');
            $table->foreignId('accountant_year_id')->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year');
            //************************ */
            $table->string('name')->nullable();
            $table->date('date')->nullable();
            $table->bigInteger('amount');



            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grant_persons');
    }
}
