<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoanTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loan', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->foreignId('accountant_year_id')->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year');
            //************************ */
            $table->string('name')->nullable();
            $table->date('first_pay_date')->nullable();
            $table->bigInteger('amount'); //المبلغ المستلف
            $table->bigInteger('pay_amount'); //الدفعة الشهرية
            $table->bigInteger('sum_amount'); //مجموع المدفوع



            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loan');
    }
}
