<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoanMovementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loan_movement', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->foreignId('pay_id')->constrained('pay')->onDelete('cascade');
            $table->foreignId('loan_id')->constrained('loan')->onDelete('cascade');
            $table->foreignId('accountant_year_id')->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year');
            //************************ */
            $table->bigInteger('amount');



            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loan_movement');
    }
}
