<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeletedSequenceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deleted_sequence', function (Blueprint $table) {
            $table->id();
            $table->foreignId('accountant_year_id')->nullable()->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year')->nullable();
            $table->string('name');
            $table->String('sequence');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deleted_sequence');
    }
}
