<?php

namespace App\Http\Controllers;


use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use App\ApiCode;
use Validator;
use App\Models\AccountantYear;

class AccountantYearController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth:api',);
    }


    public function add(Request $request)
    {
        $rules =
            [
                'year' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }

        $year = AccountantYear::where('year', $request->year)->first();
        if ($year)
            return $this->sendResponse(
                $year,
                "here are your year",
                ApiCode::SUCCESS,
                1
            );
        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $year = AccountantYear::create($input);
        return $this->sendResponse(
            $year,
            "here are your year",
            ApiCode::SUCCESS,
            1
        );
    }
}
