<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;
use App\ApiCode;
use App\Models\Person;
use App\Models\Company;
use App\User;
use App\Models\Setting;
use App\Models\Movement;
use Illuminate\Support\Str;
use Validator;
use Illuminate\Http\Request;

use Carbon\Carbon;

class AuthController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => [
            'login',
            'register',
            'webRegister',
            'mainPage',
        ]]);
    }


    public function mainPage(Request $request)
    {

        $now = Carbon::now();
        //echo $now->year;
        //echo $now->month;
        //echo $now->weekOfYear;


        $countCompanies = Company::count();
        $countPersons = Person::count();
        $newCompanies = Company::whereDoesntHave('years', function ($query) use ($now) {
            $query->where('year', '<', $now->year);
        })->count();
        $newPersons = Person::whereDoesntHave('years', function ($query) use ($now) {
            $query->where('year', '<', $now->year);
        })->count();





        return $this->sendResponse([
            'countCompanies' => $countCompanies,
            'countPersons' => $countPersons,
            'newCompanies' => $newCompanies,
            'newPersons' => $newPersons,
            'settings' =>   Setting::all(),
        ], "main fetched successfully", ApiCode::SUCCESS, 0);
    }

    public function webRegister(Request $request)
    {

        $rules =
            [
                'username' => 'required',
                'data_id' => 'required', // رقم الاضبارة
                'record_no' => 'required', //السجل التجاري
                'password' => 'required',
                'role' => 'required', //10 = persons , 11=company


            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }

        $input = $request->all();

        $user = User::where('username',   $input['username'])->where('param1',   $input['data_id'])
            ->where('param2',   $input['record_no'])->first();
        if ($user)
            return $this->webLogin($user);
        $input['param1'] = $input['data_id'];
        $input['param2'] = $input['record_no'];
        $result = array();
        if ($input['role'] == 10) {
            $person =   Person::where('id', $input['data_id'])->where('record_no', $input['record_no'])->firstOrFail();
            array_push($result, ['data' => $person]);
            //48
            $mov = Movement::whereHas('receive', function ($query) use ($person) {
                $query->where('person_id', $person->id);
            })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
            $total = 0;
            if ($mov)
                $total = $mov->amount;
            array_push($result, ['lastPay' => $total]);
        } else  if ($input['role'] == 11) {
            $company =   Company::where('id', $input['data_id'])->where('record_no', $input['record_no'])->firstOrFail();
            array_push($result, ['data' => $company]);
            $mov = Movement::whereHas('receive', function ($query) use ($company) {
                $query->where('company_id', $company->id);
            })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
            $total = 0;
            if ($mov)
                $total = $mov->amount;
            array_push($result, ['lastPay' => $total]);
        } else {
            return $this->sendResponse(
                null,
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $user = User::create($input);
        $token = auth()->login($user);
        $user->remember_token = $token;
        $user->save();

        return $this->sendResponse([
            'token' => $token,
            'result' => $result,
            'user' => $user
        ], "user created successfully", ApiCode::CREATED, 0);
    }

    public function webLogin($user)
    {
        if ($token = auth()
            ->attempt([
                'username' => request('username'),
                'password' => request('password')
            ])
        ) {
            $user = auth()->user();
            $user->remember_token = $token;
            $user->save();
            if ($user->status == 0) {
                $result = array();
                if ($user->role == 10) {
                    $person =   Person::where('id', $user->param1)->where('record_no', $user->param2)->firstOrFail();
                    array_push($result, ['data' => $person]);
                    $mov = Movement::whereHas('receive', function ($query) use ($person) {
                        $query->where('person_id', $person->id);
                    })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
                    $total = 0;
                    if ($mov)
                        $total = $mov->amount;
                    array_push($result, ['lastPay' => $total]);
                } else  if ($user->role == 11) {
                    $company =   Company::where('id', $user->param1)->where('record_no', $user->param2)->firstOrFail();
                    array_push($result, ['data' => $company]);
                    $mov = Movement::whereHas('receive', function ($query) use ($company) {
                        $query->where('company_id', $company->id);
                    })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
                    $total = 0;
                    if ($mov)
                        $total = $mov->amount;
                    array_push($result, ['lastPay' => $total]);
                }
                return $this->sendResponse([
                    'token' => $token,
                    'result' => $result,
                    'user' => $user
                ], "user fetched successfully", ApiCode::SUCCESS, 0);
            } else
                return  $this->sendResponse(
                    null,
                    "user not authorized",
                    ApiCode::UNAUTHORIZED,
                    1
                );
        } else {
            //if authentication is unsuccessfully, notice how I return json parameters
            return $this->sendResponse(
                null,
                "Invalid Phone or Password",
                ApiCode::BAD_REQUEST,
                1
            );
        }
    }

    public function me(Request $request)
    {


        $user = auth()->user();
        $result = array();
        if ($user->role == 10) {
            $person =   Person::where('id', $user->param1)->where('record_no', $user->param2)->firstOrFail();
            array_push($result, ['data' => $person]);
            $mov = Movement::whereHas('receive', function ($query) use ($person) {
                $query->where('person_id', $person->id);
            })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
            $total = 0;
            if ($mov)
                $total = $mov->amount;
            array_push($result, ['lastPay' => $total]);
        } else  if ($user->role == 11) {
            $company =   Company::where('id', $user->param1)->where('record_no', $user->param2)->firstOrFail();
            array_push($result, ['data' => $company]);
            $mov = Movement::whereHas('receive', function ($query) use ($company) {
                $query->where('company_id', $company->id);
            })->where('account_id', 48)->orderBy('created_at', 'desc')->first();
            $total = 0;
            if ($mov)
                $total = $mov->amount;
            array_push($result, ['lastPay' => $total]);
        }
        return $this->sendResponse([
            'result' => $result,
            'user' => $user
        ], "user fetched successfully", ApiCode::SUCCESS, 0);
    }
    public function register(Request $request)
    {

        $rules =
            [
                'username' => 'required|unique:users',
                'password' => 'required',
                'role' => 'required',

            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $input = $request->all();

        $user = User::create($input);
        $token = auth()->login($user);
        $user->remember_token = $token;
        $user->save();

        return $this->sendResponse([
            'token' => $token,
            'user' => $user,
        ], "user created successfully", ApiCode::CREATED, 0);
    }




    public function login(Request $request)
    {

        $rules =
            [
                'username' => 'required',  /* |regex:/(0)[0-9]{9}/' */
                'password' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        if ($token = auth()
            ->attempt([
                'username' => request('username'),
                'password' => request('password')
            ])
        ) {
            $user = auth()->user();
            $user->remember_token = $token;
            $user->save();
            if ($user->status == 0)
                return  $this->sendResponse([
                    'token' => $token,
                    'user' => $user,
                ], "User successfully logged in",  ApiCode::SUCCESS, 0);
            else
                return  $this->sendResponse(
                    null,
                    "user not authorized",
                    ApiCode::UNAUTHORIZED,
                    1
                );
        } else {
            //if authentication is unsuccessfully, notice how I return json parameters
            return $this->sendResponse(
                null,
                "Invalid Phone or Password",
                ApiCode::BAD_REQUEST,
                1
            );
        }
    }


    public function edit($id, Request $request)
    {
        $rules =
            [
                'username' => 'unique:users',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $client = User::findOrFail($id);

        if ($request->has('password'))  if ($request->password != null)
            $client->password = $request->password;


        if ($request->has('status')) if ($request->status != null)
            $client->status = $request->status;



        if ($request->has('username')) if ($request->username != null)
            $client->username = $request->username;
        if ($request->has('role')) if ($request->role != null)
            $client->role = $request->role;

        if ($request->has('notes')) if ($request->notes != null)
            $client->notes = $request->notes;

        if ($request->has('notes2')) if ($request->notes2 != null)
            $client->notes2 = $request->notes2;
        if ($request->has('notes3')) if ($request->notes3 != null)
            $client->notes3 = $request->notes3;

        $client->save();
        $client = User::where('id', $client->id)->first();
        return  $this->sendResponse($client, "user edited successfully!",  ApiCode::SUCCESS, 0);
    }

    public function all()
    {
        $users =  User::all();
        return  $this->sendResponse(
            $users,
            "here are your mainPage content!",
            ApiCode::SUCCESS,
            0
        );
    }

    public function dump()
    {
        \Illuminate\Support\Facades\Artisan::call('backup:run');

        return  $this->sendResponse(
            null,
            "data dumped successfully",
            ApiCode::SUCCESS,
            0
        );
    }
}
