<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use App\ApiCode;
use Validator;
use App\Models\Sequence;
use App\Models\Deposit;
use App\Models\Account;
use App\Models\Movement;

class DepositController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth:api',);
    }


    public function add(Request $request)
    {
        /*
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'notification_num',
        'date',
        'account_name',
        'note',
*/

        $rules =
            [
                'year' => 'required',
                'accountant_year_id' => 'required',
                'notification_num' => 'required',
                'date' => 'required',
                'account_id' => 'required',
                'amount' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $sequence = Sequence::where('name', 'deposit')
            ->where('accountant_year_id', $request->accountant_year_id)
            ->where('year', $request->year)
            ->first();
        if (!$sequence) {
            $sequence = Sequence::create([
                'name' => 'deposit',
                'accountant_year_id' => $request->accountant_year_id,
                'year' => $request->year
            ]);
        }
        $sequence->sequence += 1;
        $sequence->save();
        $account = Account::where('id', $request->account_id)->firstOrFail();

        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $input['account_name'] = $account->name;
        $input['sequence'] = $sequence->sequence;
        $deposit = Deposit::create($input);
        $movement = Movement::create([
            'deposit_id' =>   $deposit->id,
            'accountant_year_id' => $request->accountant_year_id,
            'year' => $request->year,
            'rcd_type' => 2,
            'is_debtor' => 1,
            'account_id' =>  $account->id,
            'amount' => $request->amount,
            'account_gp_id' => ($account->id > 62 && $account->id < 70) ? 62 : $account->id,

        ]);
        $movement2 = Movement::create([
            'deposit_id' =>   $deposit->id,
            'accountant_year_id' => $request->accountant_year_id,
            'year' => $request->year,
            'rcd_type' => 2,
            'is_debtor' => 0,
            'account_id' =>  48,
            'amount' =>  $request->amount,
            'account_gp_id' => 48,
        ]);
        return $this->sendResponse(
            [Deposit::where('id', $deposit->id)->first()],
            "deposit created successfully",
            ApiCode::CREATED,
            0
        );
    }
    public function edit($id, Request $request)
    {

        $deposit = Deposit::where('id', $id)->firstOrFail();
        if ($request->has('amount'))
            if ($request->amount != null) {
                foreach ($deposit->movements as $movement) {
                    $movement->amount = $request->amount;
                    $movement->save();
                }
            }

        if ($request->has('status'))
            if ($request->status != null) {
                $deposit->status = $request->status;
            }
        if ($request->has('notification_num'))
            if ($request->notification_num != null) {
                $deposit->notification_num = $request->notification_num;
            }
        if ($request->has('date'))
            if ($request->date != null) {
                $deposit->date = $request->date;
            }
        if ($request->has('note'))
            if ($request->note != null) {
                $deposit->note = $request->note;
            }

        $deposit->save();
        return $this->sendResponse(
            [Deposit::where('id', $deposit->id)->first()],
            "deposit created successfully",
            ApiCode::SUCCESS,
            0
        );
    }
    public function all(Request $request)
    {


        if ($request->query("year") == null || $request->query("accountant_year_id") == null) {
            return $this->sendResponse(
                null,
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $deposits =  Deposit::where('year', $request->query("year"))
            ->where('accountant_year_id', $request->query("accountant_year_id"))
            ->where(
                function ($query) use ($request) {
                    if ($request->query("sequence") != null) {
                        $sequence = $request->query("sequence");
                        return $query->where('sequence', $sequence);
                    }
                }

            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("name") != null) {
                        $account_name = $request->query("name");
                        return $query->where('account_name', 'like', '%' . $account_name . '%');
                    }
                }

            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("from") != null) {
                        $from = $request->query("from");
                        $from =  str_replace('/', '-', $from);

                        return $query->whereDate('date', '>', date("Y-m-d", strtotime($from)));
                    }
                }

            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("to") != null) {

                        $to = $request->query("to");

                        $to =  str_replace('/', '-', $to);
                        return $query->whereDate('date', '<', date("Y-m-d", strtotime($to)));
                    }
                }

            )->orderBy('created_at', 'DESC')
            ->get();


        return  $this->sendResponse(
            $deposits,
            "here are your deposits!",
            ApiCode::SUCCESS,
            0
        );
    }
}
