<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Request as MyRequest;
use Validator;

use App\ApiCode;

class RequestController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth:api',);
    }


    public function all(Request $request)
    {

        $requestt =  MyRequest::where(
            function ($query) use ($request) {
                if ($request->query("id") != null) {
                    $id = $request->query("id");

                    return $query->where('id', $id);
                }
            }

        )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("name") != null) {
                        $name = $request->query("name");
                        return $query->where('name', 'like', '%' . $name . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("city") != null) {
                        $city = $request->query("city");
                        return $query->where('city', 'like', '%' . $city . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("record_no") != null) {
                        $record_no = $request->query("record_no");
                        return $query->where('record_no', 'like', '%' . $record_no . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("degree") != null) {
                        $degree = $request->query("degree");
                        return $query->where('degree',  $degree);
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("logo") != null) {
                        $logo = $request->query("logo");
                        return $query->where('logo', 'like', '%' . $logo . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("address") != null) {
                        $address = $request->query("address");
                        return $query->where('address', 'like', '%' . $address . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("trade_type") != null) {
                        $trade_type = $request->query("trade_type");
                        return $query->where('trade_type', 'like', '%' . $trade_type . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("mother_name") != null) {
                        $mother_name = $request->query("mother_name");
                        return $query->where('mother_name', 'like', '%' . $mother_name . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("location") != null) {
                        $location = $request->query("location");
                        return $query->where('location', 'like', '%' . $location . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("digit") != null) {
                        $digit = $request->query("digit");
                        return $query->where('digit', 'like', '%' . $digit . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("personality_number") != null) {
                        $personality_number = $request->query("personality_number");
                        return $query->where('personality_number', 'like', '%' . $personality_number . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("out_from") != null) {
                        $out_from = $request->query("out_from");
                        return $query->where('out_from', 'like', '%' . $out_from . '%');
                    }
                }
            )
            ->where(
                function ($query) use ($request) {
                    if ($request->query("type") != null) {
                        $status = $request->query("type");
                        return $query->where('type',  $status);
                    }
                }
            );
        $data = $requestt->get();



        return  $this->sendResponse(
            $data,
            "here are your requests!",
            ApiCode::SUCCESS,
            0
        );
    }

    public function add(Request $request)
    {

        $rules =
            [
                'name' => 'required',
                'city' => 'required',
                'hire_date' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }
        $user = auth()->user();
        $input = $request->all();
        $input['user_id'] = $user->id;
        $requestt = MyRequest::create($input);

        return $this->sendResponse([
            MyRequest::find($requestt->id),
        ], "Request created successfully", ApiCode::CREATED, 0);
    }

    public function edit($id, Request $request)
    {
        $requestt = MyRequest::findOrFail($id);
        $user = auth()->user();


        if ($request->has('name'))
            if ($request->name != null)
                $requestt->name =    $request->name;


        if ($request->has('city'))
            if ($request->city != null)
                $requestt->city =    $request->city;


        if ($request->has('hire_date'))
            if ($request->hire_date != null)
                $requestt->hire_date =    $request->hire_date;


        if ($request->has('degree'))
            if ($request->degree != null)
                $requestt->degree =    $request->degree;


        if ($request->has('record_no'))
            if ($request->record_no != null)
                $requestt->record_no =    $request->record_no;


        if ($request->has('logo'))
            if ($request->logo != null)
                $requestt->logo =    $request->logo;


        if ($request->has('mailbox'))
            if ($request->mailbox != null)
                $requestt->mailbox =    $request->mailbox;


        if ($request->has('nativity'))
            if ($request->nativity != null)
                $requestt->nativity =    $request->nativity;


        if ($request->has('address'))
            if ($request->address != null)
                $requestt->address =    $request->address;


        if ($request->has('trade_type'))
            if ($request->name != null)
                $requestt->trade_type =    $request->trade_type;

        if ($request->has('mother_name'))
            if ($request->mother_name != null)
                $requestt->mother_name =    $request->mother_name;

        if ($request->has('location'))
            if ($request->location != null)
                $requestt->location =    $request->location;

        if ($request->has('digit'))
            if ($request->digit != null)
                $requestt->digit =    $request->digit;

        if ($request->has('year'))
            if ($request->year != null)
                $requestt->year =    $request->year;


        if ($request->has('phone1'))
            if ($request->phone1 != null)
                $requestt->phone1 =    $request->phone1;

        if ($request->has('phone2'))
            if ($request->phone2 != null)
                $requestt->phone2 =    $request->phone2;

        if ($request->has('personality_number'))
            if ($request->personality_number != null)
                $requestt->personality_number =    $request->personality_number;

        if ($request->has('out_from'))
            if ($request->out_from != null)
                $requestt->out_from =    $request->out_from;


        $requestt->updated_by = $user->id;
        $requestt->save();
        return $this->sendResponse([
            MyRequest::find($requestt->id),
        ], "Request updated successfully", ApiCode::SUCCESS, 0);
    }
}
