<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\ApiCode;
use App\Http\Controllers\AppBaseController;

use Illuminate\Support\Str;
use App\Models\Setting;
use Validator;

class SettingsController extends AppBaseController
{
    public function __construct()
    {
        $this->middleware('auth:api',);
    }

    public function all(Request $request)
    {

        $settings = Setting::where(
            function ($query) use ($request) {
                if ($request->query('type') != null)
                    $query->where('type', $request->query('type'));
            }
        )->get();
        return $this->sendResponse(
            $settings,
            "Setting fetched successfully",
            ApiCode::SUCCESS,
            0
        );
    }
    public function add(Request $request)
    {
        $rules =
            [

                'key' => 'required',
                'value' => 'required',
                'type' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }

        $input = $request->all();
        $setting = Setting::create($input);

        if ($request->has('image')) {
            $uuid = Str::uuid();
            $setting->addMediaFromRequest('image')->usingName($uuid)->usingFileName($uuid . '.' . $request->image->extension())->toMediaCollection('images');
            $setting->save();
            //Log::error($request->file);
        }
        return $this->sendResponse(
            [Setting::where('id', $setting->id)->first()],
            "Setting created successfully",
            ApiCode::CREATED,
            0
        );
    }


    public function edit($id, Request $request)
    {
        $rules =
            [
                'value' => 'required',
            ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return $this->sendResponse(
                $validator->errors(),
                "validation errors",
                ApiCode::BAD_REQUEST,
                1
            );
        }

        $input = $request->all();
        $setting = Setting::where('id', $id)->firstOrFail();
        $setting->value = $input['value'];
        if (array_key_exists("value2", $input))
            $setting->value2 = $input['value2'];

        if (array_key_exists("value3", $input))
            $setting->value3 = $input['value3'];
        $setting->save();

        if ($request->has('image')) {
            $setting->media->each->delete();
            $setting->save();
            $uuid = Str::uuid();
            $setting->addMediaFromRequest('image')->usingName($uuid)->usingFileName($uuid . '.' . $request->image->extension())->toMediaCollection('images');
            $setting->save();
            //Log::error($request->file);
        }
        return $this->sendResponse(
            [Setting::where('id', $setting->id)->first()],
            "Setting updated successfully",
            ApiCode::SUCCESS,
            0
        );
    }

    public function delete($id, Request $request)
    {
        $setting  = Setting::findOrFail($id);
        $setting->delete();
        return $this->sendResponse(
            null,
            "Setting deleted successfully",
            ApiCode::SUCCESS,
            0
        );
    }
}
