<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Company
 * @package App\Models
 * @version December 20, 2020, 11:19 am UTC
 *
 * @property \App\Models\User $updatedBy
 * @property \App\Models\User $user
 * @property \Illuminate\Database\Eloquent\Collection $companyDetails
 * @property \Illuminate\Database\Eloquent\Collection $companyDetail2s
 * @property \Illuminate\Database\Eloquent\Collection $phones
 * @property \Illuminate\Database\Eloquent\Collection $years
 * @property integer $user_id
 * @property integer $updated_by
 * @property string $name
 * @property string $city
 * @property string $hire_date
 * @property string $degree
 * @property string $record_no
 * @property string $logo
 * @property string $mailbox
 * @property string $nativity
 * @property string $address
 * @property string $trade_type
 * @property boolean $status
 * @property boolean $is_deleted
 * @property string $status_description
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Company extends Model
{


    public $table = 'companies';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    protected $with = [
        'updatedBy',
        'user',
        'companyDetails',
        'phones',
        'years',
    ];


    public $fillable = [
        'id',
        'user_id',
        'updated_by',
        'request_id',
        'name',
        'city',
        'hire_date',
        'degree',
        'record_no',
        'logo',
        'mailbox',
        'nativity',
        'address',
        'trade_type',
        'status',
        'is_deleted',
        'status_description',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'request_id' => 'integer',
        'updated_by' => 'integer',
        'name' => 'string',
        'city' => 'string',
        'hire_date' => 'string',
        'degree' => 'string',
        'record_no' => 'string',
        'logo' => 'string',
        'mailbox' => 'string',
        'nativity' => 'string',
        'address' => 'string',
        'trade_type' => 'string',
        'status' => 'integer',
        'is_deleted' => 'integer',
        'status_description' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'user_id' => 'required',
        'updated_by' => 'required',
        'name' => 'nullable|string|max:191',
        'city' => 'nullable|string|max:191',
        'hire_date' => 'nullable',
        'degree' => 'nullable|string|max:191',
        'record_no' => 'nullable|string|max:191',
        'logo' => 'nullable|string|max:191',
        'mailbox' => 'nullable|string|max:191',
        'nativity' => 'nullable|string|max:191',
        'address' => 'nullable|string|max:191',
        'trade_type' => 'nullable|string|max:191',
        'status' => 'required|boolean',
        'is_deleted' => 'required|boolean',
        'status_description' => 'nullable|string',
        'param1' => 'nullable|string|max:191',
        'param2' => 'nullable|string|max:191',
        'param3' => 'nullable|string|max:191',
        'param4' => 'nullable|string|max:191',
        'param5' => 'nullable|string|max:191',
        'param6' => 'nullable|string|max:191',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function updatedBy()
    {
        return $this->belongsTo(\App\User::class, 'updated_by');
    }
    public function request()
    {
        return $this->belongsTo(\App\Models\Request::class, 'request_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function companyDetails()
    {
        return $this->hasMany(\App\Models\CompanyDetail::class, 'company_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function phones()
    {
        return $this->hasMany(\App\Models\Phone::class, 'company_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function years()
    {
        return $this->hasMany(\App\Models\Year::class, 'company_id');
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function grantPeople()
    {
        return $this->hasMany(\App\Models\GrantPerson::class, 'company_id');
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function receives()
    {
        return $this->hasMany(\App\Models\Receive::class, 'company_id');
    }
}
