<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CompanyDetail
 * @package App\Models
 * @version December 20, 2020, 8:23 am UTC
 *
 * @property \App\Models\Company $company
 * @property \App\Models\Company $name
 * @property \App\Models\User $user
 * @property integer $user_id
 * @property integer $company_id
 * @property integer $name
 * @property string $mother_name
 * @property string $father_name
 * @property string $digit
 * @property string $birthday
 * @property boolean $is_authorized
 * @property boolean $status
 * @property string $status_description
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class CompanyDetail extends Model
{


    public $table = 'company_details';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'user_id',
        'company_id',
        'name',
        'mother_name',
        'father_name',
        'digit',
        'birthday',
        'is_authorized',
        'status',
        'status_description',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'company_id' => 'integer',
        'name' => 'String',
        'mother_name' => 'string',
        'father_name' => 'string',
        'digit' => 'string',
        'birthday' => 'string',
        'is_authorized' => 'integer',
        'status' => 'integer',
        'status_description' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'user_id' => 'required',
        'company_id' => 'nullable',
        'name' => 'nullable',
        'mother_name' => 'nullable|string|max:191',
        'father_name' => 'nullable|string|max:191',
        'digit' => 'nullable|string|max:191',
        'birthday' => 'nullable|string|max:191',
        'is_authorized' => 'required|integer',
        'status' => 'required|integer',
        'status_description' => 'nullable|string',
        'param1' => 'nullable|string|max:191',
        'param2' => 'nullable|string|max:191',
        'param3' => 'nullable|string|max:191',
        'param4' => 'nullable|string|max:191',
        'param5' => 'nullable|string|max:191',
        'param6' => 'nullable|string|max:191',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function company()
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function name()
    {
        return $this->belongsTo(\App\Models\Company::class, 'name');
    }
    public function grantPeople()
    {
        return $this->hasMany(\App\Models\GrantPerson::class, 'company_detail_id');
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }
}
