<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class DeletedSequence
 * @package App\Models
 * @version January 2, 2021, 2:14 pm UTC
 *
 * @property \App\Models\AccountantYear $accountantYear
 * @property integer $accountant_year_id
 * @property integer $year
 * @property string $name
 * @property string $sequence
 */
class DeletedSequence extends Model
{


    public $table = 'deleted_sequence';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'accountant_year_id',
        'year',
        'name',
        'sequence'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'name' => 'string',
        'sequence' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'accountant_year_id' => 'nullable',
        'year' => 'nullable|integer',
        'name' => 'required|string|max:191',
        'sequence' => 'required|string|max:191',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }
}
