<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class GrantPerson
 * @package App\Models
 * @version December 29, 2020, 1:48 pm UTC
 *
 * @property \App\Models\AccountantYear $accountantYear
 * @property \App\Models\Company $company
 * @property \App\Models\Person $person
 * @property \App\Models\Receive $receive
 * @property integer $person_id
 * @property integer $company_id
 * @property integer $receive_id
 * @property integer $accountant_year_id
 * @property integer $year
 * @property string $name
 * @property string $date
 * @property integer $amount
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class GrantPerson extends Model
{

    public $table = 'grant_persons';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';





    public $fillable = [
        'person_id',
        'company_id',
        'company_detail_id',
        'receive_id',
        'accountant_year_id',
        'year',
        'name',
        'date',
        'amount',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'person_id' => 'integer',
        'company_id' => 'integer',
        'company_detail_id' => 'integer',
        'receive_id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'name' => 'string',
        'date' => 'date',
        'amount' => 'integer',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'person_id' => 'nullable',
        'company_id' => 'nullable',
        'receive_id' => 'required',
        'accountant_year_id' => 'required',
        'year' => 'required|integer',
        'name' => 'nullable|string|max:191',
        'date' => 'nullable',
        'amount' => 'required',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function company()
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }
    public function companyDetail()
    {
        return $this->belongsTo(\App\Models\CompanyDetail::class, 'company_detail_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function person()
    {
        return $this->belongsTo(\App\Models\Person::class, 'person_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function receive()
    {
        return $this->belongsTo(\App\Models\Receive::class, 'receive_id');
    }
}
