<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Loan
 * @package App\Models
 * @version December 29, 2020, 1:49 pm UTC
 *
 * @property \App\Models\AccountantYear $accountantYear
 * @property \App\Models\Employee $employee
 * @property \Illuminate\Database\Eloquent\Collection $loanMovements
 * @property integer $employee_id
 * @property integer $accountant_year_id
 * @property integer $year
 * @property string $name
 * @property string $first_pay_date
 * @property integer $amount
 * @property integer $pay_amount
 * @property integer $sum_amount
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Loan extends Model
{


    public $table = 'loan';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';




    public $fillable = [
        'employee_id',
        'accountant_year_id',
        'year',
        'name',
        'first_pay_date',
        'amount',
        'pay_amount',
        'sum_amount',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'employee_id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'name' => 'string',
        'first_pay_date' => 'date',
        'amount' => 'integer',
        'pay_amount' => 'integer',
        'sum_amount' => 'integer',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'employee_id' => 'required',
        'accountant_year_id' => 'required',
        'year' => 'required|integer',
        'name' => 'nullable|string|max:191',
        'first_pay_date' => 'nullable',
        'amount' => 'required',
        'pay_amount' => 'required',
        'sum_amount' => 'required',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function employee()
    {
        return $this->belongsTo(\App\Models\Employee::class, 'employee_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function loanMovements()
    {
        return $this->hasMany(\App\Models\LoanMovement::class, 'loan_id');
    }
}
