<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Movement
 * @package App\Models
 * @version December 29, 2020, 1:44 pm UTC
 *
 * @property \App\Models\Account $accountGp
 * @property \App\Models\Account $account
 * @property \App\Models\AccountantYear $accountantYear
 * @property \App\Models\Deposit $deposit
 * @property \App\Models\Pay $pay
 * @property \App\Models\Deposit $plain
 * @property \App\Models\Receive $receive
 * @property \App\Models\Rent $rent
 * @property integer $deposit_id
 * @property integer $rent_id
 * @property integer $receive_id
 * @property integer $pay_id
 * @property integer $plain_id
 * @property integer $accountant_year_id
 * @property integer $year
 * @property boolean $rcd_type
 * @property integer $account_id
 * @property integer $account_gp_id
 * @property boolean $is_debtor
 * @property integer $amount
 * @property string $note
 * @property string $param1
 * @property string $param2
 * @property string $param3
 * @property string $param4
 * @property string $param5
 * @property string $param6
 */
class Movement extends Model
{

    public $table = 'movement';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';


    protected $with = [
        'account',
    ];



    public $fillable = [
        'deposit_id',
        'rent_id',
        'receive_id',
        'pay_id',
        'plain_id',
        'accountant_year_id',
        'year',
        'rcd_type',
        'account_id',
        'account_gp_id',
        'is_debtor',
        'amount',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'deposit_id' => 'integer',
        'rent_id' => 'integer',
        'receive_id' => 'integer',
        'pay_id' => 'integer',
        'plain_id' => 'integer',
        'accountant_year_id' => 'integer',
        'year' => 'integer',
        'rcd_type' => 'integer',
        'account_id' => 'integer',
        'account_gp_id' => 'integer',
        'is_debtor' => 'integer',
        'amount' => 'integer',
        'note' => 'string',
        'param1' => 'string',
        'param2' => 'string',
        'param3' => 'string',
        'param4' => 'string',
        'param5' => 'string',
        'param6' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'deposit_id' => 'nullable',
        'rent_id' => 'nullable',
        'receive_id' => 'nullable',
        'pay_id' => 'nullable',
        'plain_id' => 'nullable',
        'accountant_year_id' => 'required',
        'year' => 'required|integer',
        'rcd_type' => 'required|boolean',
        'account_id' => 'required',
        'account_gp_id' => 'required',
        'is_debtor' => 'required|boolean',
        'amount' => 'required',
        'note' => 'nullable|string',
        'param1' => 'nullable|string',
        'param2' => 'nullable|string',
        'param3' => 'nullable|string',
        'param4' => 'nullable|string',
        'param5' => 'nullable|string',
        'param6' => 'nullable|string',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountGp()
    {
        return $this->belongsTo(\App\Models\Account::class, 'account_gp_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function account()
    {
        return $this->belongsTo(\App\Models\Account::class, 'account_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function accountantYear()
    {
        return $this->belongsTo(\App\Models\AccountantYear::class, 'accountant_year_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function deposit()
    {
        return $this->belongsTo(\App\Models\Deposit::class, 'deposit_id')->without('movements');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function pay()
    {
        return $this->belongsTo(\App\Models\Pay::class, 'pay_id')->without(['movements', 'account']);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function plain()
    {
        return $this->belongsTo(\App\Models\Plain::class, 'plain_id')->without('movements');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function receive()
    {
        return $this->belongsTo(\App\Models\Receive::class, 'receive_id')->without([
            'movements',
            'person',
            'company',
            'grantPeople'
        ]);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function rent()
    {
        return $this->belongsTo(\App\Models\Rent::class, 'rent_id')->without('movements');
    }
}
