<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Request
 * @package App\Models
 * @version December 25, 2020, 6:51 pm UTC
 *
 * @property \App\Models\User $updatedBy
 * @property \App\Models\User $user
 * @property \Illuminate\Database\Eloquent\Collection $companies
 * @property \Illuminate\Database\Eloquent\Collection $people
 * @property integer $user_id
 * @property integer $updated_by
 * @property string $name
 * @property string $city
 * @property string $hire_date
 * @property string $degree
 * @property string $record_no
 * @property string $logo
 * @property string $mailbox
 * @property string $nativity
 * @property string $address
 * @property string $trade_type
 * @property string $phone1
 * @property string $phone2
 * @property string $mother_name
 * @property string $location
 * @property string $digit
 * @property string $year
 * @property string $personality_number
 * @property string $out_from
 * @property boolean $type
 */
class Request extends Model
{

    public $table = 'requests';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';


    public $fillable = [
        'user_id',
        'updated_by',
        'name',
        'city',
        'hire_date',
        'degree',
        'record_no',
        'logo',
        'mailbox',
        'nativity',
        'address',
        'trade_type',
        'phone1',
        'phone2',
        'mother_name',
        'location',
        'digit',
        'year',
        'personality_number',
        'out_from',
        'type'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'updated_by' => 'integer',
        'name' => 'string',
        'city' => 'string',
        'hire_date' => 'date:d-m-Y',
        'degree' => 'string',
        'record_no' => 'string',
        'logo' => 'string',
        'mailbox' => 'string',
        'nativity' => 'string',
        'address' => 'string',
        'trade_type' => 'string',
        'phone1' => 'string',
        'phone2' => 'string',
        'mother_name' => 'string',
        'location' => 'string',
        'digit' => 'string',
        'year' => 'string',
        'personality_number' => 'string',
        'out_from' => 'string',
        'type' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'user_id' => 'required',
        'updated_by' => 'nullable',
        'name' => 'nullable|string|max:191',
        'city' => 'nullable|string|max:191',
        'hire_date' => 'nullable',
        'degree' => 'nullable|string|max:191',
        'record_no' => 'nullable|string|max:191',
        'logo' => 'nullable|string|max:191',
        'mailbox' => 'nullable|string|max:191',
        'nativity' => 'nullable|string|max:191',
        'address' => 'nullable|string|max:191',
        'trade_type' => 'nullable|string|max:191',
        'phone1' => 'nullable|string|max:191',
        'phone2' => 'nullable|string|max:191',
        'mother_name' => 'nullable|string|max:191',
        'location' => 'nullable|string|max:191',
        'digit' => 'nullable|string|max:191',
        'year' => 'nullable|string|max:191',
        'personality_number' => 'nullable|string|max:191',
        'out_from' => 'nullable|string|max:191',
        'type' => 'required|boolean',
        'created_at' => 'nullable',
        'updated_at' => 'nullable'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function updatedBy()
    {
        return $this->belongsTo(\App\User::class, 'updated_by');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function companies()
    {
        return $this->hasMany(\App\Models\Company::class, 'request_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
    public function people()
    {
        return $this->hasMany(\App\Models\Person::class, 'request_id');
    }
}
