<?php

namespace App\Repositories;

use App\Models\DeletedSequence;
use App\Repositories\BaseRepository;

/**
 * Class DeletedSequenceRepository
 * @package App\Repositories
 * @version January 2, 2021, 2:14 pm UTC
*/

class DeletedSequenceRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'accountant_year_id',
        'year',
        'name',
        'sequence'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return DeletedSequence::class;
    }
}
