<?php

namespace App\Repositories;

use App\Models\DiwanRecord;
use App\Repositories\BaseRepository;

/**
 * Class DiwanRecordRepository
 * @package App\Repositories
 * @version June 4, 2021, 2:47 pm UTC
*/

class DiwanRecordRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'sequence',
        'accountant_year_id',
        'year',
        'date',
        'type',
        'sender',
        'conclusion',
        'location',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return DiwanRecord::class;
    }
}
