<?php

namespace App\Repositories;

use App\Models\LoanMovement;
use App\Repositories\BaseRepository;

/**
 * Class LoanMovementRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:50 pm UTC
*/

class LoanMovementRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'employee_id',
        'pay_id',
        'loan_id',
        'accountant_year_id',
        'year',
        'amount',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return LoanMovement::class;
    }
}
