<?php

namespace App\Repositories;

use App\Models\Movement;
use App\Repositories\BaseRepository;

/**
 * Class MovementRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:44 pm UTC
*/

class MovementRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'deposit_id',
        'rent_id',
        'receive_id',
        'pay_id',
        'plain_id',
        'accountant_year_id',
        'year',
        'rcd_type',
        'account_id',
        'account_gp_id',
        'is_debtor',
        'amount',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Movement::class;
    }
}
