<?php

namespace App\Repositories;

use App\Models\NewFeed;
use App\Repositories\BaseRepository;

/**
 * Class NewFeedRepository
 * @package App\Repositories
 * @version June 9, 2021, 5:59 pm UTC
*/

class NewFeedRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'title',
        'content',
        'type',
        'seenCount',
        'tags',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return NewFeed::class;
    }
}
