<?php

namespace App\Repositories;

use App\Models\New;
use App\Repositories\BaseRepository;

/**
 * Class NewRepository
 * @package App\Repositories
 * @version June 9, 2021, 5:32 pm UTC
*/

class NewRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'title',
        'content',
        'type',
        'seenCount',
        'tags',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return New::class;
    }
}
