<?php

namespace App\Repositories;

use App\Models\Pay;
use App\Repositories\BaseRepository;

/**
 * Class PayRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:43 pm UTC
*/

class PayRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'name',
        'condition',
        'date',
        'note',
        'account_id',
        'check_num',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Pay::class;
    }
}
