<?php

namespace App\Repositories;

use App\Models\ReadyAccount;
use App\Repositories\BaseRepository;

/**
 * Class ReadyAccountRepository
 * @package App\Repositories
 * @version December 29, 2020, 2:12 pm UTC
*/

class ReadyAccountRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'account_id',
        'type',
        'name',
        'amount'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return ReadyAccount::class;
    }
}
