<?php

namespace App\Repositories;

use App\Models\Rent;
use App\Repositories\BaseRepository;

/**
 * Class RentRepository
 * @package App\Repositories
 * @version December 29, 2020, 1:42 pm UTC
*/

class RentRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'sequence',
        'user_id',
        'accountant_year_id',
        'year',
        'status',
        'name',
        'statement',
        'date',
        'note',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Rent::class;
    }
}
