<?php

namespace App\Repositories;

use App\Models\Request;
use App\Repositories\BaseRepository;

/**
 * Class RequestRepository
 * @package App\Repositories
 * @version December 25, 2020, 6:51 pm UTC
*/

class RequestRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'user_id',
        'updated_by',
        'name',
        'city',
        'hire_date',
        'degree',
        'record_no',
        'logo',
        'mailbox',
        'nativity',
        'address',
        'trade_type',
        'phone1',
        'phone2',
        'mother_name',
        'location',
        'digit',
        'year',
        'personality_number',
        'out_from',
        'type'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Request::class;
    }
}
