<?php

namespace App\Repositories;

use App\Models\Sequence;
use App\Repositories\BaseRepository;

/**
 * Class SequenceRepository
 * @package App\Repositories
 * @version December 24, 2020, 6:54 pm UTC
*/

class SequenceRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'name',
        'sequence'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Sequence::class;
    }
}
