<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('persons', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('cascade');
            $table->foreignId('request_id')->constrained('requests')->onDelete('cascade');

            $table->string('name')->nullable();
            $table->string('city')->nullable();
            $table->string('hire_date')->nullable();
            $table->string('degree')->nullable();
            $table->string('record_no')->nullable();
            $table->string('logo')->nullable();
            $table->string('mailbox')->nullable();
            $table->string('nativity')->nullable();
            $table->text('address')->nullable();
            $table->text('trade_type')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('location')->nullable();
            $table->string('digit')->nullable();
            $table->string('year')->nullable();
            $table->string('personality_number')->nullable();
            $table->string('out_from')->nullable();
            $table->longText('remarks')->nullable();
            $table->unsignedTinyInteger('status')->default(0);
            $table->unsignedTinyInteger('is_deleted')->default(0); // 0= no, 1=deleted
            $table->longText('status_description')->nullable();
            // 0 = active
            // 1 = (مشطوب)
            // 2 = (متوفي)
            // 3 = (ملغاة)
            // 4 = (محروم)
            $table->string('birthday')->nullable();


            $table->string('param1')->nullable();
            $table->string('param2')->nullable();
            $table->string('param3')->nullable();
            $table->string('param4')->nullable();
            $table->string('param5')->nullable();
            $table->string('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('persons');
    }
}
