<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMovementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('movement', function (Blueprint $table) {
            $table->id();
            $table->foreignId('deposit_id')->nullable()->constrained('deposit')->onDelete('cascade');
            $table->foreignId('rent_id')->nullable()->constrained('rent')->onDelete('cascade');
            $table->foreignId('receive_id')->nullable()->constrained('receive')->onDelete('cascade');
            $table->foreignId('pay_id')->nullable()->constrained('pay')->onDelete('cascade');
            $table->foreignId('plain_id')->nullable()->constrained('plain')->onDelete('cascade');

            $table->foreignId('accountant_year_id')->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year');
            //************************ */
            $table->unsignedTinyInteger('rcd_type'); // 0 =rcv , 1=pay , 2= dps, 3= rnt, 4=pln
            $table->foreignId('account_id')->constrained('accounts')->onDelete('cascade');
            $table->foreignId('account_gp_id')->constrained('accounts')->onDelete('cascade');
            $table->unsignedTinyInteger('is_debtor')->default(0);
            // 0 = creditor دائن
            // 1 = debtor مدين
            $table->bigInteger('amount');
            $table->text('note')->nullable();

            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('movement');
    }
}
