<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDiwanRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diwan_records', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->integer('sequence');
            $table->foreignId('accountant_year_id')->nullable()->constrained('accountant_years')->onDelete('cascade');
            $table->integer('year')->nullable();
            $table->date('date')->nullable();
            $table->unsignedTinyInteger('type')->default(0); // 0 =receive , 1=send
            $table->text('sender')->nullable();
            $table->text('conclusion')->nullable();
            $table->text('location')->nullable();
            $table->text('number')->nullable();

            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diwan_records');
    }
}
