<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
            $table->id();


            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->text('title')->nullable();
            $table->longText('content')->nullable();
            $table->unsignedTinyInteger('type')->default(0); // 0 =news , 1= faaliat , 2= visits, 3= اجتماعات
            $table->integer('seenCount')->default(0);
            $table->longText('tags')->nullable();
            $table->text('param1')->nullable();
            $table->text('param2')->nullable();
            $table->text('param3')->nullable();
            $table->text('param4')->nullable();
            $table->text('param5')->nullable();
            $table->text('param6')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news');
    }
}
