<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;




Route::group([
    'prefix' => 'auth/v1'
], function ($router) {

    Route::post('/register', 'AuthController@register');
    Route::post('/login', 'AuthController@login');
    Route::get('/logout', 'AuthController@logout');
    Route::post('/edit/{id}', 'AuthController@edit');
    Route::get('/all', 'AuthController@all');
    Route::get('/dump', 'AuthController@dump');
    Route::post('/webRegister', 'AuthController@webRegister');
    Route::get('/mainPage', 'AuthController@mainPage');
    Route::get('/me', 'AuthController@me');
});

Route::group([
    'prefix' => 'companies/v1'
], function ($router) {

    Route::post('/add', 'CompanyController@add');
    Route::post('/edit/{id}', 'CompanyController@edit');
    Route::post('/addDetail/{id}', 'CompanyController@addDetail');
    Route::get('/all', 'CompanyController@all');
    Route::post('/editDetail/{id}', 'CompanyController@editDetail');
    Route::get('/deleteDetail/{id}', 'CompanyController@deleteDetail');


    Route::post('/addPhone/{id}', 'CompanyController@addPhone');
    Route::post('/editPhone/{id}', 'CompanyController@editPhone');
    Route::get('/deletePhone/{id}', 'CompanyController@deletePhone');

    Route::post('/addYear/{id}', 'CompanyController@addYear');
    Route::post('/editYear/{id}', 'CompanyController@editYear');
    Route::get('/deleteYear/{id}', 'CompanyController@deleteYear');
    Route::get('/resetCompanySequence', 'CompanyController@resetCompanySequence');

    Route::get('/delete/{id}', 'CompanyController@delete');
});

Route::group([
    'prefix' => 'persons/v1'
], function ($router) {

    Route::get('/all', 'PersonController@all');
    Route::post('/add', 'PersonController@add');

    Route::post('/edit/{id}', 'PersonController@edit');


    Route::post('/addPhone/{id}', 'PersonController@addPhone');
    Route::post('/editPhone/{id}', 'PersonController@editPhone');
    Route::post('/addYear/{id}', 'PersonController@addYear');
    Route::post('/editYear/{id}', 'PersonController@editYear');
    Route::get('/resetPersonSequence', 'PersonController@resetPersonSequence');

    Route::get('/deleteYear/{id}', 'PersonController@deleteYear');

    Route::get('/delete/{id}', 'PersonController@delete');
});
Route::group([
    'prefix' => 'requests/v1'
], function ($router) {

    Route::get('/all', 'RequestController@all');
    Route::post('/add', 'RequestController@add');

    Route::post('/edit/{id}', 'RequestController@edit');
});
Route::group([
    'prefix' => 'accounts/v1'
], function ($router) {

    Route::get('/all', 'AccountController@all');

    Route::post('/add', 'AccountController@add');
});
Route::group([
    'prefix' => 'accountant_years/v1'
], function ($router) {

    Route::post('/add', 'AccountantYearController@add');
});
Route::group([
    'prefix' => 'deposit/v1'
], function ($router) {

    Route::post('/add', 'DepositController@add');
    Route::get('/all', 'DepositController@all');
    Route::post('/edit/{id}', 'DepositController@edit');
});
Route::group([
    'prefix' => 'rent/v1'
], function ($router) {

    Route::get('/all', 'RentController@all');
    Route::post('/add', 'RentController@add');
    Route::post('/edit/{id}', 'RentController@edit');
});
Route::group([
    'prefix' => 'plain/v1'
], function ($router) {

    Route::get('/all', 'PlainController@all');
    Route::post('/add', 'PlainController@add');
    Route::post('/edit/{id}', 'PlainController@edit');
});
Route::group([
    'prefix' => 'receive/v1'
], function ($router) {

    Route::get('/all', 'ReceiveController@all');
    Route::post('/add', 'ReceiveController@add');
    Route::get('/delete/{id}', 'ReceiveController@delete');
    Route::post('/edit/{id}', 'ReceiveController@edit');

    Route::get('/boxMovement', 'ReceiveController@boxMovement');
    Route::get('/ledger', 'ReceiveController@ledger');
    Route::get('/trialBalance', 'ReceiveController@trialBalance');
    Route::get('/monthlyBoxMovement', 'ReceiveController@MonthlyBoxMovement');
});
Route::group([
    'prefix' => 'ready/v1'
], function ($router) {

    Route::get('/all', 'ReadyAccountController@all');
    Route::post('/edit', 'ReadyAccountController@edit');
});
Route::group([
    'prefix' => 'pay/v1'
], function ($router) {

    Route::get('/all', 'PayController@all');
    Route::post('/add', 'PayController@add');
    Route::get('/delete/{id}', 'PayController@delete');
    Route::post('/edit/{id}', 'PayController@edit');
});
Route::group([
    'prefix' => 'diwan/v1'
], function ($router) {

    Route::get('/all', 'DiwanRecordController@all');
    Route::post('/add', 'DiwanRecordController@add');
    Route::get('/delete/{id}', 'DiwanRecordController@delete');
    Route::post('/edit/{id}', 'DiwanRecordController@edit');
});
Route::group([
    'prefix' => 'news/v1'
], function ($router) {

    Route::get('/main', 'NewsFeedController@main');
    Route::get('/gallery', 'NewsFeedController@gallery');
    Route::get('/all', 'NewsFeedController@all');
    Route::post('/add', 'NewsFeedController@add');
    Route::get('/delete/{id}', 'NewsFeedController@delete');
    Route::post('/edit/{id}', 'NewsFeedController@edit');
});
Route::group([
    'prefix' => 'settings/v1'
], function ($router) {

    Route::post('/add', 'SettingsController@add');
    Route::post('/edit/{id}', 'SettingsController@edit');
    Route::get('/delete/{id}', 'SettingsController@delete');
    Route::get('/all', 'SettingsController@all');
    //**
});
